#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_PatientChange : BaseTest 
	{
		#region Variables

		private BOL.PatientChange _tstPC;
		private DataTable _dtPatientChange;

		#endregion
		
		#region Setup / TearDown

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtPatientChange = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PatientChange");
				//
				if (this._dtPatientChange == null || this._dtPatientChange.Rows.Count == 0)
				{
					InsertUpdatedPatientTestData(true);
					//
					this._dtPatientChange = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PatientChange", true);
				}
				//
				this.RefreshData = false;
			}
			//
			_tstPC = new BOL.PatientChange(this._dtPatientChange.Rows[0]);
		}

		[TearDown]
		protected void TearDown()
		{
			ClearPatientChangeTestData();
		}

		#endregion

		#region Test Properties

		[Test]
		public void FromPatientDisplayVistaPatientId_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPC.FromPatientDisplayVistaPatientId = tstValue;

			Assert.IsTrue(this._tstPC.FromPatientDisplayVistaPatientId == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void FromPatientDisplayVistaPatientId_Fail()
		{
		}

		[Test]
		public void FromPatientGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstPC.FromPatientGuid = tstValue;

			Assert.IsTrue(this._tstPC.FromPatientGuid == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void FromPatientGuid_Fail()
		{
		}

		[Test]
		public void FromPatientSsn_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPC.FromPatientSsn = tstValue;

			Assert.IsTrue(this._tstPC.FromPatientSsn == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void FromPatientSsn_Fail()
		{
		}

		[Test]
		public void FromPatientIcn_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPC.FromPatientIcn = tstValue;

			Assert.IsTrue(this._tstPC.FromPatientIcn == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void FromPatientIcn_Fail()
		{
		}


		[Test]
		public void FromPatientLastName_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPC.FromPatientLastName = tstValue;

			Assert.IsTrue(this._tstPC.FromPatientLastName == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void FromPatientLastName_Fail()
		{
		}

		[Test]
		public void FromPatientFirstName_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPC.FromPatientFirstName = tstValue;

			Assert.IsTrue(this._tstPC.FromPatientFirstName == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void FromPatientFirstName_Fail()
		{
		}

		[Test]
		public void FromPatientMiddleName_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPC.FromPatientMiddleName = tstValue;

			Assert.IsTrue(this._tstPC.FromPatientMiddleName == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void FromPatientMiddleName_Fail()
		{
		}

		[Test]
		public void FromPatientDob_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;

			this._tstPC.FromPatientDob = tstValue;

			Assert.IsTrue(this._tstPC.FromPatientDob == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void FromPatientDob_Fail()
		{
		}

		[Test]
		public void FromPatientDeathDate_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;

			this._tstPC.FromPatientDeathDate = tstValue;

			Assert.IsTrue(this._tstPC.FromPatientDeathDate == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void FromPatientDeathDate_Fail()
		{
		}

		[Test]
		public void FromPatientSexCode_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPC.FromPatientSexCode = tstValue;

			Assert.IsTrue(this._tstPC.FromPatientSexCode == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void FromPatientSexCode_Fail()
		{
		}

		[Test]
		public void FromSsnPseudoIndicator_Pass()
		{
			bool tstValue = true;

			this._tstPC.FromSsnPseudoIndicator = tstValue;

			Assert.IsTrue(this._tstPC.FromSsnPseudoIndicator == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void FromSsnPseudoIndicator_Fail()
		{
		}

		[Test]
		public void MergeFromVistaPatientId_Pass()
		{
			long tstValue = (long) new Random().Next(1, 999999999) * 100;

			this._tstPC.MergeFromVistaPatientId = tstValue;

			Assert.IsTrue(this._tstPC.MergeFromVistaPatientId == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void MergeFromVistaPatientId_Fail()
		{
		}

		[Test]
		public void MergeToVistaPatientId_Pass()
		{
			long tstValue = (long) new Random().Next(1, 999999999) * 100;

			this._tstPC.MergeToVistaPatientId = tstValue;

			Assert.IsTrue(this._tstPC.MergeToVistaPatientId == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void MergeToVistaPatientId_Fail()
		{
		}

		[Test]
		public void PatientChangeStatusCode_Pass()
		{
			Common.PatientChangeStatus tstValue = Common.PatientChangeStatus.PendingProcessing;

			this._tstPC.PatientChangeStatusCode = tstValue;

			Assert.IsTrue(this._tstPC.PatientChangeStatusCode == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientChangeStatusCode_Fail()
		{
		}

		[Test]
		public void PatientChangeGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstPC.PatientChangeGuid = tstValue;

			Assert.IsTrue(this._tstPC.PatientChangeGuid == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientChangeGuid_Fail()
		{
		}

		[Test]
		public void ToPatientDisplayVistaPatientId_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPC.ToPatientDisplayVistaPatientId = tstValue;

			Assert.IsTrue(this._tstPC.ToPatientDisplayVistaPatientId == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ToPatientDisplayVistaPatientId_Fail()
		{
		}

		[Test]
		public void ToPatientGuid_Pass()
		{
			System.Guid  tstValue = System.Guid.NewGuid();

			this._tstPC.ToPatientGuid = tstValue;

			Assert.IsTrue(this._tstPC.ToPatientGuid == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ToPatientGuid_Fail()
		{
		}

		[Test]
		public void ToPatientSsn_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPC.ToPatientSsn = tstValue;

			Assert.IsTrue(this._tstPC.ToPatientSsn == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ToPatientSsn_Fail()
		{
		}

		[Test]
		public void ToPatientIcn_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPC.ToPatientIcn = tstValue;

			Assert.IsTrue(this._tstPC.ToPatientIcn == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ToPatientIcn_Fail()
		{
		}

		[Test]
		public void ToPatientLastName_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPC.ToPatientLastName = tstValue;

			Assert.IsTrue(this._tstPC.ToPatientLastName == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ToPatientLastName_Fail()
		{
		}

		[Test]
		public void ToPatientFirstName_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPC.ToPatientFirstName = tstValue;

			Assert.IsTrue(this._tstPC.ToPatientFirstName == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ToPatientFirstName_Fail()
		{
		}

		[Test]
		public void ToPatientMiddleName_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPC.ToPatientMiddleName = tstValue;

			Assert.IsTrue(this._tstPC.ToPatientMiddleName == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ToPatientMiddleName_Fail()
		{
		}

		[Test]
		public void ToPatientDob_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;

			this._tstPC.ToPatientDob = tstValue;

			Assert.IsTrue(this._tstPC.ToPatientDob == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ToPatientDob_Fail()
		{
		}

		[Test]
		public void ToPatientDeathDate_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;

			this._tstPC.ToPatientDeathDate = tstValue;

			Assert.IsTrue(this._tstPC.ToPatientDeathDate == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ToPatientDeathDate_Fail()
		{
		}

		[Test]
		public void ToPatientSexCode_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPC.ToPatientSexCode = tstValue;

			Assert.IsTrue(this._tstPC.ToPatientSexCode == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ToPatientSexCode_Fail()
		{
		}

		[Test]
		public void ToSsnPseudoIndicator_Pass()
		{
			bool tstValue = true;

			this._tstPC.ToSsnPseudoIndicator = tstValue;

			Assert.IsTrue(this._tstPC.ToSsnPseudoIndicator == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ToSsnPseudoIndicator_Fail()
		{
		}

		[Test]
		public void Ctor_Blank_Pass()
		{
			BOL.PatientChange tmpPC = new BOL.PatientChange();

			Assert.IsNotNull(tmpPC);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Blank_Fail()
		{
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			System.Guid fromGuid = (System.Guid)this._dtPatientChange.Rows[0][TABLES.PatientChange.FromPatientGuid];
			System.Guid toGuid = (System.Guid)this._dtPatientChange.Rows[0][TABLES.PatientChange.ToPatientGuid];

			BOL.PatientChange tmpPC = new BOL.PatientChange(this._dtPatientChange.Rows[0]);
			Assert.IsNotNull(tmpPC);
			Assert.IsTrue(tmpPC.FromPatientGuid == fromGuid);
			Assert.IsTrue(tmpPC.ToPatientGuid == toGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}

		[Test]
		public void NotificationReceivedDate_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;

			this._tstPC.NotificationReceivedDate = tstValue;

			Assert.IsTrue(this._tstPC.NotificationReceivedDate == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void NotificationReceivedDate_Fail()
		{
		}

		[Test]
		public void ActiveDivisionsAlertViewed_Pass()
		{
			string tstValue = "589^589A4";

			this._tstPC.ActiveDivisionsAlertViewed = tstValue;

			Assert.IsTrue(this._tstPC.ActiveDivisionsAlertViewed == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ActiveDivisionsAlertViewed_Fail()
		{
		}

		[Test]
		public void DivisionsWithActiveOrders_Pass()
		{
			string tstValue = "589^589A4^589A7";

			this._tstPC.DivisionsWithActiveOrders = tstValue;

			Assert.IsTrue(this._tstPC.DivisionsWithActiveOrders == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DivisionsWithActiveOrders_Fail()
		{
		}

		[Test]
		public void DivisionDelimiter_Pass()
		{
			string divisionDelimiter = "^";
			//
			Assert.AreEqual( divisionDelimiter, PatientChange.DivisionDelimiter );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DivisionDelimiter_Fail()
		{
		}

		[Test]
		public void DivisionDelimiterSplitter_Pass()
		{
			char [] divisionDelimiterSplitter = new char[]{ '^' };
			//
			Assert.AreEqual( divisionDelimiterSplitter, PatientChange.DivisionDelimiterSplitter );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DivisionDelimiterSplitter_Fail()
		{
		}

		#endregion	

		#region Test Methods

		[Test]
		public void UpdatePatientChangeStatus_Pass()
		{
			Guid patientChangeGuid = InsertUpdatedPatientTestData(false);
			//
			DataRow patientChangeDataRow = UnitTestUtil.RunSQLGetDataRow("SELECT * FROM PatientChange WHERE PatientChangeGuid = '" + patientChangeGuid + "'");
			//
			BOL.PatientChange tmpPC = new BOL.PatientChange(patientChangeDataRow);
			//
			tmpPC.PatientChangeStatusCode = Common.PatientChangeStatus.InProcess;
			//
			bool tstValue = tmpPC.UpdatePatientChangeStatus();
			//
			Assert.IsTrue(tstValue);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void UpdatePatientChangeStatus_Fail()
		{
			this._tstPC.PatientChangeStatusCode = Common.PatientChangeStatus.Unknown;
			this._tstPC.PatientChangeGuid = Guid.Empty;
			
			this._tstPC.UpdatePatientChangeStatus();
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			BOL.PatientChange tmpPC = new BOL.PatientChange(this._dtPatientChange.Rows[0]);

			DataRow dr = tmpPC.LoadDataRowFromThis(this._dtPatientChange.NewRow());

			Assert.IsTrue((System.Guid)dr[TABLES.PatientChange.FromPatientGuid] == tmpPC.FromPatientGuid);
			Assert.IsTrue((System.Guid)dr[TABLES.PatientChange.ToPatientGuid] == tmpPC.ToPatientGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		// **************************************************************************************************************
		// ****	PENDING PATIENT MERGES ***
		// *******************************

		[Test]
		public void GetPendingPatientMergesCount_Pass()
		{
			Patient mergeFromPatient = null;
			Patient mergeToPatient = null;
			//
			int pendingMergesCount = BOL.PatientChange.GetPendingPatientMergesCount();
			
			System.Guid pcGuid = System.Guid.Empty;

			if (pendingMergesCount == 0)
			{
				mergeFromPatient = new Patient(CreatePatientTestData(new BOL.AboRh(Common.ABO.A, Common.RH.Positive)));
				mergeToPatient = new Patient(CreatePatientTestData(new BOL.AboRh(Common.ABO.A, Common.RH.Positive)));
				//
				pcGuid = InsertMergePatientTestData(mergeFromPatient, mergeToPatient);
			}
			pendingMergesCount = BOL.PatientChange.GetPendingPatientMergesCount();
			//
			Assert.IsTrue(pendingMergesCount > 0);
			//

			//PatientChange record needs to be cleaned up first or else the Patient Deletes will fail
			if (mergeFromPatient != null || mergeToPatient != null)
				UnitTestUtil.RunSQL("DELETE FROM PatientChange WHERE PatientChangeGuid = '" + pcGuid.ToString() + "'");

			if (mergeFromPatient != null)
			{
				DeletePatientTestData(mergeFromPatient.PatientGuid);
			}
			//
			if (mergeToPatient != null)
			{
				DeletePatientTestData(mergeToPatient.PatientGuid);
			}
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetPendingPatientMergesCount_Fail()
		{
		}

		[Test]
		public void GetPendingPatientMergesDetails_Pass()
		{
			Patient mergeFromPatient = null;
			Patient mergeToPatient = null;
			//
			PatientChange [] mergeList = BOL.PatientChange.GetPendingPatientMergesDetails();
			//

			System.Guid pcGuid = System.Guid.Empty;

			if (mergeList == null || mergeList.Length == 0)
			{
				mergeFromPatient = new Patient(CreatePatientTestData(new BOL.AboRh(Common.ABO.A, Common.RH.Positive)));
				mergeToPatient = new Patient(CreatePatientTestData(new BOL.AboRh(Common.ABO.A, Common.RH.Positive)));
				//
				pcGuid = InsertMergePatientTestData(mergeFromPatient, mergeToPatient);
			}
			mergeList = BOL.PatientChange.GetPendingPatientMergesDetails();
			//
			Assert.IsTrue(mergeList != null);
			Assert.IsTrue(mergeList.Length >= 0);
			//

			//PatientChange record needs to be cleaned up first or else the Patient Deletes will fail
			if (mergeFromPatient != null || mergeToPatient != null)
				UnitTestUtil.RunSQL("DELETE FROM PatientChange WHERE PatientChangeGuid = '" + pcGuid.ToString() + "'");

			if (mergeFromPatient != null)
			{
				DeletePatientTestData(mergeFromPatient.PatientGuid);
			}
			//
			if (mergeToPatient != null)
			{
				DeletePatientTestData(mergeToPatient.PatientGuid);
			}
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetPendingPatientMergesDetails_Fail()
		{
		}

		// **************************************************************************************************************
		// ****	DECEASED PATIENTS ***
		// **************************

		[Test]
		public void GetRecentlyDeceasedPatientsCount_Pass()
		{
			int recentlyDeceasedPatientsCount = BOL.PatientChange.GetRecentlyDeceasedPatientsCount();
			//
			if(recentlyDeceasedPatientsCount == 0)
			{
				InsertUpdatedPatientTestDataWithOrders(true);
			}
			//
			recentlyDeceasedPatientsCount = BOL.PatientChange.GetRecentlyDeceasedPatientsCount();
			//
			Assert.IsTrue(recentlyDeceasedPatientsCount > 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetRecentlyDeceasedPatientsCount_Fail()
		{
		}

		[Test]
		public void GetRecentlyDeceasedPatientsDetails_Pass()
		{
			PatientChange [] tstValue = BOL.PatientChange.GetRecentlyDeceasedPatientsDetails();
			//
			if(tstValue == null || tstValue.Length == 0)
			{
				InsertUpdatedPatientTestDataWithOrders(true);
			}
			//
			tstValue = BOL.PatientChange.GetRecentlyDeceasedPatientsDetails();
			//
			Assert.IsTrue(tstValue.Length >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetRecentlyDeceasedPatientsDetails_Fail()
		{
		}

		// **************************************************************************************************************
		// ****	UPDATED PATIENTS ***
		// *************************

		[Test]
		public void GetRecentlyUpdatedPatientCount_Pass()
		{
			int recentlyUpdatedPatientsCount = BOL.PatientChange.GetRecentlyUpdatedPatientCount();
			//
			if(recentlyUpdatedPatientsCount == 0)
			{
				InsertUpdatedPatientTestDataWithOrders(false);
			}
			//
			recentlyUpdatedPatientsCount = BOL.PatientChange.GetRecentlyUpdatedPatientCount();
			//
			Assert.IsTrue(recentlyUpdatedPatientsCount > 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetRecentlyUpdatedPatientCount_Fail()
		{
		}

		[Test]
		public void GetRecentlyUpdatedPatientDetails_Pass()
		{
			PatientChange [] tstValue = BOL.PatientChange.GetRecentlyUpdatedPatientDetails();
			//
			if(tstValue == null || tstValue.Length == 0)
			{
				InsertUpdatedPatientTestDataWithOrders(false);
			}
			//
			tstValue = BOL.PatientChange.GetRecentlyUpdatedPatientDetails();
			//
			Assert.IsTrue(tstValue.Length >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetRecentlyUpdatedPatientDetails_Fail()
		{
		}

		[Test]
		public void Ctor_Static_Pass()
		{
			string divisionDelimiter = "^";
			char [] divisionDelimiterSplitter = new char[]{ '^' };
			//
			Assert.AreEqual( divisionDelimiter, PatientChange.DivisionDelimiter );
			Assert.AreEqual( divisionDelimiterSplitter, PatientChange.DivisionDelimiterSplitter );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Static_Fail()
		{
		}

		[Test]
		public void AllUpdatesViewed_Pass()
		{
			PatientChange pcTest = new PatientChange();
			//
			// TEST 1
			ArrayList activeDivisionsList = new ArrayList("589A4^589A6".Split(PatientChange.DivisionDelimiterSplitter));
			ArrayList divisionsWithActiveOrdersList = new ArrayList("589A4^589A6".Split(PatientChange.DivisionDelimiterSplitter)); 
			Assert.IsTrue( pcTest.AllUpdatesViewed(activeDivisionsList, divisionsWithActiveOrdersList) );
			//
			// TEST 2
			activeDivisionsList = new ArrayList("589".Split(PatientChange.DivisionDelimiterSplitter));
			divisionsWithActiveOrdersList = new ArrayList("589A4^589A6^589^589A7".Split(PatientChange.DivisionDelimiterSplitter)); 
			Assert.IsFalse( pcTest.AllUpdatesViewed(activeDivisionsList, divisionsWithActiveOrdersList) );
			//
			// TEST 3
			activeDivisionsList = new ArrayList("589A4^589A6^589^589A7".Split(PatientChange.DivisionDelimiterSplitter));
			divisionsWithActiveOrdersList = new ArrayList("589A4".Split(PatientChange.DivisionDelimiterSplitter)); 
			Assert.IsTrue( pcTest.AllUpdatesViewed(activeDivisionsList, divisionsWithActiveOrdersList) );
			//
			// TEST 4
			activeDivisionsList = new ArrayList("589".Split(PatientChange.DivisionDelimiterSplitter));
			Assert.IsTrue( pcTest.AllUpdatesViewed(activeDivisionsList, null) );
			//
			// TEST 5
			Assert.IsFalse( pcTest.AllUpdatesViewed(null, divisionsWithActiveOrdersList) );
			Assert.IsTrue( pcTest.AllUpdatesViewed(null, null) );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AllUpdatesViewed_Fail()
		{
		}

		[Test]
		public void BuildAlertViewedString_Pass()
		{
			string activeDivisions = "589A4" + PatientChange.DivisionDelimiter + "589A6";
			string divisionCodeToAdd = "589";
			ArrayList activeDivisionsList = new ArrayList(activeDivisions.Split(PatientChange.DivisionDelimiterSplitter));
			string newActiveDivisions = PatientChange.BuildAlertViewedString( divisionCodeToAdd, activeDivisionsList );
			activeDivisionsList = new ArrayList(newActiveDivisions.Split(PatientChange.DivisionDelimiterSplitter));
			Assert.IsTrue( activeDivisionsList.Contains(divisionCodeToAdd) );
			//
			activeDivisions = "589A4" + PatientChange.DivisionDelimiter + "589A6" + PatientChange.DivisionDelimiter + "589";
			activeDivisionsList = new ArrayList(activeDivisions.Split(PatientChange.DivisionDelimiterSplitter));
			newActiveDivisions = PatientChange.BuildAlertViewedString( divisionCodeToAdd, activeDivisionsList );
			activeDivisionsList = new ArrayList(newActiveDivisions.Split(PatientChange.DivisionDelimiterSplitter));
			Assert.IsTrue( activeDivisionsList.Contains(divisionCodeToAdd) );
			Assert.AreEqual( activeDivisions, newActiveDivisions );
			//
			newActiveDivisions = PatientChange.BuildAlertViewedString( divisionCodeToAdd, null );
			activeDivisionsList = new ArrayList(newActiveDivisions.Split(PatientChange.DivisionDelimiterSplitter));
			Assert.IsTrue( activeDivisionsList.Contains(divisionCodeToAdd) );
			Assert.AreEqual( divisionCodeToAdd, newActiveDivisions );
			//
			divisionCodeToAdd = null;
			newActiveDivisions = PatientChange.BuildAlertViewedString( divisionCodeToAdd, null );
			Assert.IsNull( newActiveDivisions );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BuildAlertViewedString_Fail()
		{
		}

		#endregion

		#region Helper Functions

		#region Insert Test Data

		/// <summary>
		/// Inserts merge test data into PatientChange
		/// </summary>
		/// <returns>Row change count</returns>
		public static Guid InsertMergePatientTestData(Patient mergeFromPatient, Patient mergeToPatient)
		{		
			StringBuilder query = new StringBuilder();
			// 
			Guid patientChangeGuid = Guid.NewGuid();
			//
			query.Remove(0, query.Length);
			query.Append("INSERT INTO PatientChange (PatientChangeGuid, FromPatientGuid, ToPatientGuid, MergeFromVistaPatientId, ");
			query.Append("MergeToVistaPatientId, PatientChangeStatusCode, NotificationReceivedDate, LastUpdateFunctionId, LastUpdateUser, LastUpdateDate)");
			query.Append("VALUES ('");
			query.Append(patientChangeGuid).Append("', '");
			query.Append(mergeFromPatient.PatientGuid).Append("', '");
			query.Append(mergeToPatient.PatientGuid).Append("', '");
			query.Append(mergeFromPatient.VistaPatientId).Append("', '");
			query.Append(mergeToPatient.VistaPatientId).Append("', 'P', GetUtcDate(), 0, 'UNITTEST', GetUtcDate())");
			//
			int rowCount = UnitTestUtil.RunSQL(query.ToString());
			//
			Assert.IsTrue(rowCount > 0, "UNABLE TO INSERT PATIENT CHANGE DATA!");
			//
			return patientChangeGuid;
		}

		/// <summary>
		/// Inserts patient update test data into PatientChange;
		/// we need to create both a test and component order
		/// </summary>
		/// <returns>Row change count</returns>
		public static Guid InsertUpdatedPatientTestData(bool mostRecentPatient)
		{		
			string patientQuery = "SELECT TOP 1 PatientGuid FROM Patient ORDER BY LastUpdateDate DESC";
			//
			if(!mostRecentPatient)
			{
				patientQuery = "SELECT TOP 1 PatientGuid FROM Patient ORDER BY LastUpdateDate ASC";
			}
			Guid patientGuid = (Guid)UnitTestUtil.RunSQLGetDataRow(patientQuery)[TABLES.Patient.PatientGuid];
			//
			StringBuilder query = new StringBuilder();
			// 
			Guid patientChangeGuid = Guid.NewGuid();
			//
			query.Remove(0, query.Length);
			query.Append("DECLARE @now DATETIME ");
			query.Append("DECLARE @newdob DATETIME ");
			query.Append("DECLARE @dob DATETIME ");
			query.Append("DECLARE @ssn CHAR(9) ");
			query.Append("DECLARE @lastname	VARCHAR(20) ");
			query.Append("DECLARE @firstname VARCHAR(20) ");
			query.Append("DECLARE @middlename VARCHAR(20) ");
			query.Append("SET @now = GETUTCDATE() ");
			query.Append("SET @dob = (SELECT PatientDob FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @ssn = (SELECT PatientSsn FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @lastname	= (SELECT PatientLastName FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @firstname = (SELECT PatientFirstName FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @middlename = (SELECT PatientMiddleName FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @newdob = DATEADD(YEAR, -10, @dob) ");
			query.Append("INSERT INTO PatientChange(PatientChangeGuid, FromPatientGuid, FromPatientSsn, FromPatientLastName, FromPatientFirstName, ");
			query.Append("FromPatientMiddleName,  FromPatientDob, ToPatientGuid, ToPatientSsn, ToPatientLastName, ToPatientFirstName, ToPatientMiddleName,  ");
			query.Append("ToPatientDob, PatientChangeStatusCode, NotificationReceivedDate, LastUpdateDate, LastUpdateUser,  LastUpdateFunctionId) VALUES( ");
			query.Append("'").Append(patientChangeGuid).Append("', ");
			query.Append("'").Append(patientGuid).Append("', ");
			query.Append("@ssn, ");
			query.Append("@lastname, ");
			query.Append("@firstname, ");
			query.Append("@middlename, ");
			query.Append("@dob, ");
			query.Append("'").Append(patientGuid).Append("', ");
			query.Append("'101010101', ");
			query.Append("'UPDATED', ");
			query.Append("'PATIENT', ");
			query.Append("'IS', ");
			query.Append("@newdob, ");
			query.Append("'P', ");
			query.Append("@now, ");
			query.Append("@now, ");
			query.Append("'UNITTEST', ");
			query.Append("'0') ");
			//
			int rowCount = UnitTestUtil.RunSQL(query.ToString());
			//
			Assert.IsTrue(rowCount > 0, "UNABLE TO INSERT PATIENT CHANGE DATA!");
			//
			return patientChangeGuid;
		}

		/// <summary>
		/// Inserts patient update test data into PatientChange;
		/// the date includes a deceased date; also inserts orders 
		/// for the patient
		/// </summary>
		/// <returns>Row change count</returns>
		public static Guid InsertUpdatedPatientTestDataWithOrders(bool setDeathDate)
		{		
			Guid patientGuid = Guid.NewGuid();
			DataTable dtInsPatient = SprocHelper.GetInsertPatientSprocTable(patientGuid);
			bool retValue = BOL.Patient.InsertPatient(dtInsPatient.Rows[0], Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, retValue, "PatientInsert");
			//
			#region From OrderedTest.SaveTestResults_Pass

			bool result = false;
			Common.LogonUser.LogonUserDUZ = "UnitTest";
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderReceivedDatetime + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuidAboRh = Guid.NewGuid();
			string insertOrderedTestAboRh = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestAboRh += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestAboRh += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestAboRh += "VALUES (";
			insertOrderedTestAboRh += "'" + orderedTestGuidAboRh.ToString() + "',";
			insertOrderedTestAboRh += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestAboRh += "'1',";
			insertOrderedTestAboRh += "'A',";
			insertOrderedTestAboRh += "'N',";
            insertOrderedTestAboRh += "'" + SprocHelper.GetNewCprsOrderNumber() + "',";
			insertOrderedTestAboRh += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestAboRh += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestAboRh += "'UnitTestUser',";
			insertOrderedTestAboRh += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuidABS = Guid.NewGuid();
			string insertOrderedTestABS = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestABS += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestABS += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestABS += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestABS += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestABS += "VALUES (";
			insertOrderedTestABS += "'" + orderedTestGuidABS.ToString() + "',";
			insertOrderedTestABS += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestABS += "'3',";
			insertOrderedTestABS += "'A',";
			insertOrderedTestABS += "'P',";
            insertOrderedTestABS += "'" + SprocHelper.GetNewCprsOrderNumber() + "',";
			insertOrderedTestABS += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestABS += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestABS += "'UnitTestUser',";
			insertOrderedTestABS += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuidDAT = Guid.NewGuid();
			string insertOrderedTestDAT = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestDAT += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestDAT += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestDAT += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestDAT += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestDAT += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestDAT += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestDAT += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestDAT += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestDAT += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestDAT += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestDAT += "VALUES (";
			insertOrderedTestDAT += "'" + orderedTestGuidDAT.ToString() + "',";
			insertOrderedTestDAT += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestDAT += "'4',";
			insertOrderedTestDAT += "'A',";
			insertOrderedTestDAT += "'P',";
            insertOrderedTestDAT += "'" + SprocHelper.GetNewCprsOrderNumber() + "',";
			insertOrderedTestDAT += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestDAT += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestDAT += "'UnitTestUser',";
			insertOrderedTestDAT += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuidAGT = Guid.NewGuid();
			string insertOrderedTestAGT = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestAGT += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestAGT += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestAGT += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestAGT += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestAGT += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestAGT += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestAGT += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestAGT += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestAGT += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestAGT += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestAGT += "VALUES (";
			insertOrderedTestAGT += "'" + orderedTestGuidAGT.ToString() + "',";
			insertOrderedTestAGT += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestAGT += "'12',";
			insertOrderedTestAGT += "'A',";
			insertOrderedTestAGT += "'P',";
            insertOrderedTestAGT += "'" + SprocHelper.GetNewCprsOrderNumber() + "',";
			insertOrderedTestAGT += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestAGT += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestAGT += "'UnitTestUser',";
			insertOrderedTestAGT += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedTestGuidABID = Guid.NewGuid();
			string insertOrderedTestABID = "INSERT INTO ORDEREDTEST (";
			insertOrderedTestABID += TABLES.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTestABID += TABLES.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTestABID += TABLES.OrderedTest.OrderableTestId + ",";
			insertOrderedTestABID += TABLES.OrderedTest.OrderStatusCode + ",";
			insertOrderedTestABID += TABLES.OrderedTest.TaskStatusCode + ",";
			insertOrderedTestABID += TABLES.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTestABID += TABLES.OrderedTest.DivisionCode + ",";
			insertOrderedTestABID += TABLES.OrderedTest.LastUpdateDate + ",";
			insertOrderedTestABID += TABLES.OrderedTest.LastUpdateUser + ",";
			insertOrderedTestABID += TABLES.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTestABID += "VALUES (";
			insertOrderedTestABID += "'" + orderedTestGuidABID.ToString() + "',";
			insertOrderedTestABID += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTestABID += "'8',";
			insertOrderedTestABID += "'C',";
			insertOrderedTestABID += "'C',";
            insertOrderedTestABID += "'" + SprocHelper.GetNewCprsOrderNumber() + "',";
			insertOrderedTestABID += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTestABID += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTestABID += "'UnitTestUser',";
			insertOrderedTestABID += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientSpecimenGuid = Guid.NewGuid();
			string insertPatientSpecimen = "INSERT INTO PATIENTSPECIMEN (";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertPatientSpecimen += "VALUES (";
			insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
			insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'A',";
			insertPatientSpecimen += "'0',";
			insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
			insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientSpecimen += "'UnitTestUser',";
			insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid reagentGuid = Guid.NewGuid();
			string insertReagent = "INSERT INTO REAGENT (";
			insertReagent += TABLES.Reagent.ReagentGuid + ",";
			insertReagent += TABLES.Reagent.ReagentTypeId + ",";
			insertReagent += TABLES.Reagent.ReagentName + ",";
			insertReagent += TABLES.Reagent.LotNumber + ",";
			insertReagent += TABLES.Reagent.RecordStatusCode + ",";
			insertReagent += TABLES.PatientSpecimen.DivisionCode + ",";
			insertReagent += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertReagent += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertReagent += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertReagent += "VALUES (";
			insertReagent += "'" + reagentGuid.ToString() + "',";
			insertReagent += "'1',";
			insertReagent += "'TestReagent',";
			insertReagent += "'53000',";
			insertReagent += "'"+ Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active)+"',";
			insertReagent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertReagent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertReagent += "'UnitTestUser',";
			insertReagent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedTestAboRh);
			UnitTestUtil.RunSQL(insertOrderedTestABS);
			UnitTestUtil.RunSQL(insertOrderedTestDAT);
			UnitTestUtil.RunSQL(insertOrderedTestAGT);
			UnitTestUtil.RunSQL(insertOrderedTestABID);
			UnitTestUtil.RunSQL(insertPatientSpecimen);
			UnitTestUtil.RunSQL(insertReagent);

			byte[] rowVersionOrderedTestAboRh = (byte[])UnitTestUtil.RunSQLGetDataRow("SELECT RowVersion FROM OrderedTest WHERE OrderedTestGuid = '" + orderedTestGuidAboRh.ToString() + "'")[0];
			byte[] rowVersionOrderedTestABS = (byte[])UnitTestUtil.RunSQLGetDataRow("SELECT RowVersion FROM OrderedTest WHERE OrderedTestGuid = '" + orderedTestGuidABS.ToString() + "'")[0];
			byte[] rowVersionOrderedTestDAT = (byte[])UnitTestUtil.RunSQLGetDataRow("SELECT RowVersion FROM OrderedTest WHERE OrderedTestGuid = '" + orderedTestGuidDAT.ToString() + "'")[0];
			byte[] rowVersionOrderedTestAGT = (byte[])UnitTestUtil.RunSQLGetDataRow("SELECT RowVersion FROM OrderedTest WHERE OrderedTestGuid = '" + orderedTestGuidAGT.ToString() + "'")[0];
			byte[] rowVersionOrderedTestABID = (byte[])UnitTestUtil.RunSQLGetDataRow("SELECT RowVersion FROM OrderedTest WHERE OrderedTestGuid = '" + orderedTestGuidABID.ToString() + "'")[0];

			DataSet dsTestResults = new DataSet();

			DataTable dt = new DataTable("ABORh");

			dt.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dt.Columns.Add("AntiA", typeof(string));
			dt.Columns.Add("AntiB", typeof(string));
			dt.Columns.Add("AntiAB", typeof(string));
			dt.Columns.Add("A1Cells", typeof(string));
			dt.Columns.Add("BCells", typeof(string));
			dt.Columns.Add("AntiD", typeof(string));
			dt.Columns.Add("ControlD", typeof(string));			
			dt.Columns.Add("AboInterp", typeof(string));			
			dt.Columns.Add("RhInterp", typeof(string));			
			dt.Columns.Add("AboComment", typeof(string));
			dt.Columns.Add("RhComment", typeof(string));
			dt.Columns.Add("PatientGuid", typeof(Guid));
			dt.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dt.Columns.Add("OrderedTestGuid", typeof(Guid));
			dt.Columns.Add(TABLES.OrderableTest.OrderableTestId);
			dt.Columns.Add("InitialABO", typeof(string));
			dt.Columns.Add("InitialRh", typeof(string));
			dt.Columns.Add("SystemABO", typeof(string));
			dt.Columns.Add("SystemRh", typeof(string));
			dt.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dt.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dt.Columns.Add("AntiASave", typeof(bool));
			dt.Columns.Add("AntiBSave", typeof(bool));
			dt.Columns.Add("AntiABSave", typeof(bool));
			dt.Columns.Add("A1CellsSave", typeof(bool));
			dt.Columns.Add("BCellsSave", typeof(bool));
			dt.Columns.Add("AntiDSave", typeof(bool));
			dt.Columns.Add("ControlDSave", typeof(bool));			
			dt.Columns.Add("AboInterpSave", typeof(bool));			
			dt.Columns.Add("RhInterpSave", typeof(bool));	
			dt.Columns.Add("AntiAGuid", typeof(System.Guid));
			dt.Columns.Add("AntiBGuid", typeof(System.Guid));
			dt.Columns.Add("AntiABGuid", typeof(System.Guid));
			dt.Columns.Add("A1CellsGuid", typeof(System.Guid));
			dt.Columns.Add("BCellsGuid", typeof(System.Guid));
			dt.Columns.Add("AntiDGuid", typeof(System.Guid));
			dt.Columns.Add("ControlDGuid", typeof(System.Guid));			
			dt.Columns.Add("AboInterpGuid", typeof(System.Guid));			
			dt.Columns.Add("RhInterpGuid", typeof(System.Guid));
			dt.Columns.Add("AntiARowVersion", typeof(byte[]));
			dt.Columns.Add("AntiBRowVersion", typeof(byte[]));
			dt.Columns.Add("AntiABRowVersion", typeof(byte[]));
			dt.Columns.Add("A1CellsRowVersion", typeof(byte[]));
			dt.Columns.Add("BCellsRowVersion", typeof(byte[]));
			dt.Columns.Add("AntiDRowVersion", typeof(byte[]));
			dt.Columns.Add("ControlDRowVersion", typeof(byte[]));			
			dt.Columns.Add("AboInterpRowVersion", typeof(byte[]));			
			dt.Columns.Add("RhInterpRowVersion", typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));	
			dt.Columns.Add("CannedCommentGuid");
			dt.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));
			dt.Columns.Add(TABLES.Rack.RackGuid, typeof(System.Guid));
			dt.Columns.Add("CprsOrderNumber");
			dt.Columns.Add("AboRhInconclusiveException");
			dt.Columns.Add("AboRhDiscrepancyException");
			dt.Columns.Add("RepeatAboRhDiscrepancyException");

			DataRow dr = dt.NewRow();
			dr["AntiA"] = "2";
			dr["AntiB"] = "0";
			dr["AntiAB"] = "3";
			dr["A1Cells"] = "0";
			dr["BCells"] = "4";
			dr["AntiD"] = "2";
			dr["ControlD"] = "0";
			dr["AboInterp"] = "A";
			dr["RhInterp"] = "P";

			dr["AntiASave"] = true;
			dr["AntiBSave"] = true;
			dr["AntiABSave"] = true;
			dr["A1CellsSave"] = true;
			dr["BCellsSave"] = true;
			dr["AntiDSave"] = true;
			dr["ControlDSave"] = true;
			dr["AboInterpSave"] = true;
			dr["RhInterpSave"] = true;

			dr[ARTIFICIAL.PartiallyCompleted] = false;
			dr["PatientGuid"] = patientGuid;
			dr["PatientSpecimenGuid"] = patientSpecimenGuid;
			dr["OrderedTestGuid"] = orderedTestGuidAboRh;
			dr[TABLES.OrderableTest.OrderableTestId] = "1";
			dr[TABLES.SpecimenTest.CorrectedResultIndicator] = false;
			dr[ARTIFICIAL.OrderedTestRowVersion] = rowVersionOrderedTestAboRh;
            dr["CprsOrderNumber"] = SprocHelper.GetNewCprsOrderNumber();
		
			dt.Rows.Add(dr);

			dsTestResults.Tables.Add(dt);

			DataTable dtABS = new DataTable("ABS");

			//Header information
			dtABS.Columns.Add(ARTIFICIAL.Indicator, typeof(String));
			dtABS.Columns.Add("ScreeningCells",typeof(String));
			dtABS.Columns.Add(ARTIFICIAL.IS, typeof(String));
			dtABS.Columns.Add(ARTIFICIAL.C37, typeof(String));
			dtABS.Columns.Add(ARTIFICIAL.AHG, typeof(String));
			dtABS.Columns.Add(ARTIFICIAL.CC, typeof(String));
			dtABS.Columns.Add("ABSInterp", typeof(String));			
			dtABS.Columns.Add("ABSComment", typeof(String));
			dtABS.Columns.Add("PatientGuid", typeof(Guid));
			dtABS.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dtABS.Columns.Add("OrderedTestGuid", typeof(Guid));
			dtABS.Columns.Add(TABLES.OrderableTest.OrderableTestId);
			dtABS.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(String));
			dtABS.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtABS.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtABS.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtABS.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtABS.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtABS.Columns.Add("ABSInterpSave", typeof(bool));
			dtABS.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));
		
			dtABS.Columns.Add(ARTIFICIAL.ISGuid, typeof(Guid));
			dtABS.Columns.Add(ARTIFICIAL.C37Guid, typeof(Guid));
			dtABS.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
			dtABS.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtABS.Columns.Add("ABSInterpInterpGuid", typeof(Guid));

			dtABS.Columns.Add(ARTIFICIAL.ISRowVersion, typeof(byte[]));
			dtABS.Columns.Add(ARTIFICIAL.C37RowVersion, typeof(byte[]));
			dtABS.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dtABS.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dtABS.Columns.Add("ABSInterpRowVersion", typeof(byte[]));
			dtABS.Columns.Add(TABLES.Rack.RackGuid, typeof(System.Guid));
			dtABS.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
			dtABS.Columns.Add("CprsOrderNumber");

			DataRow drABS = dtABS.NewRow();
			drABS[ARTIFICIAL.IS] = "M";
			drABS[ARTIFICIAL.C37] = "";
			drABS[ARTIFICIAL.AHG] = "";
			drABS[ARTIFICIAL.CC] = "";
			drABS["ABSComment"] = "";
			drABS["ScreeningCells"] = "Auto";
			drABS["PatientGuid"] = patientGuid;
			drABS["PatientSpecimenGuid"] = patientSpecimenGuid;
			drABS["OrderedTestGuid"] = orderedTestGuidABS;
			drABS[TABLES.OrderableTest.OrderableTestId] = 3;
			drABS[ARTIFICIAL.ISSave] = true;
			drABS[ARTIFICIAL.C37Save] = true;
			drABS[ARTIFICIAL.AHGSave] = true;
			drABS[ARTIFICIAL.CCSave] = true;
			drABS["ABSInterpSave"] = true;
			drABS[TABLES.SpecimenTest.CorrectedResultIndicator] = true;
			drABS[ARTIFICIAL.PartiallyCompleted] = false;
			drABS[ARTIFICIAL.OrderedTestRowVersion] = rowVersionOrderedTestABS;
            drABS["CprsOrderNumber"] = SprocHelper.GetNewCprsOrderNumber() ;

			dtABS.Rows.Add(drABS);

			dsTestResults.Tables.Add(dtABS);

			DataTable dtDAT = new DataTable("DAT");

			dtDAT.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtDAT.Columns.Add("TestType", typeof(string));
			dtDAT.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
			dtDAT.Columns.Add(ARTIFICIAL.AHG, typeof(string));
			dtDAT.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dtDAT.Columns.Add("AHGInterp", typeof(string));
			dtDAT.Columns.Add("AHGComment", typeof(string));
			dtDAT.Columns.Add("PatientGuid", typeof(Guid));
			dtDAT.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dtDAT.Columns.Add("OrderedTestGuid", typeof(Guid));
			dtDAT.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtDAT.Columns.Add(TABLES.ReagentType.ReagentTypeId, typeof(int));
			dtDAT.Columns.Add("Manufacturer", typeof(string));
			dtDAT.Columns.Add("ExpirationDate", typeof(DateTime));
			dtDAT.Columns.Add(TABLES.OrderableTest.OrderableTestId);
			dtDAT.Columns.Add("SystemAHGInterp", typeof(string));
			dtDAT.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtDAT.Columns.Add("LotNumberSave", typeof(bool));
			dtDAT.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtDAT.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtDAT.Columns.Add("AHGInterpSave", typeof(bool));
			dtDAT.Columns.Add("CannedCommentGuid");
			dtDAT.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));
			dtDAT.Columns.Add(ARTIFICIAL.AHGGuid, typeof(System.Guid));
			dtDAT.Columns.Add(ARTIFICIAL.CCGuid, typeof(System.Guid));
			dtDAT.Columns.Add("AHGInterpGuid", typeof(System.Guid));
			dtDAT.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dtDAT.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dtDAT.Columns.Add("AHGInterpRowVersion", typeof(byte[]));
			dtDAT.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
			dtDAT.Columns.Add(TABLES.Rack.RackGuid, typeof(System.Guid));
			dtDAT.Columns.Add("CprsOrderNumber");

			DataRow drDAT = dtDAT.NewRow();
			drDAT["PatientGuid"] = patientGuid;
			drDAT["PatientSpecimenGuid"] = patientSpecimenGuid;
			drDAT["OrderedTestGuid"] = orderedTestGuidDAT;
			drDAT[ARTIFICIAL.AHG] = "2";
			drDAT[ARTIFICIAL.CC] = "3";
			drDAT["AHGInterp"] = "";

			drDAT[ARTIFICIAL.AHGSave] = true;
			drDAT[ARTIFICIAL.CCSave] = true;
			drDAT["AHGInterpSave"] = true;

			drDAT[ARTIFICIAL.PartiallyCompleted] = true;
			drDAT[TABLES.OrderableTest.OrderableTestId] = "4";
			drDAT[TABLES.SpecimenTest.CorrectedResultIndicator] = true;
			drDAT[ARTIFICIAL.OrderedTestRowVersion] = rowVersionOrderedTestDAT;
			drDAT[TABLES.Reagent.ReagentGuid] = reagentGuid;
            drDAT["CprsOrderNumber"] = SprocHelper.GetNewCprsOrderNumber();

			dtDAT.Rows.Add(drDAT);

			dsTestResults.Tables.Add(dtDAT);

			DataTable dtAGT = new DataTable("AGC");

			dtAGT.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtAGT.Columns.Add("TestType", typeof(string));
			dtAGT.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.VialId);
			dtAGT.Columns.Add(ARTIFICIAL.IS, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.RT, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.C37, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.AHG, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.Interp, typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.Comment, typeof(string));
			dtAGT.Columns.Add("PatientGuid", typeof(Guid));
			dtAGT.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dtAGT.Columns.Add("OrderedTestGuid", typeof(Guid));
			dtAGT.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtAGT.Columns.Add(TABLES.ReagentType.ReagentTypeId, typeof(int));
			dtAGT.Columns.Add("Manufacturer", typeof(string));
			dtAGT.Columns.Add("ExpirationDate", typeof(DateTime));
			dtAGT.Columns.Add(TABLES.OrderableTest.OrderableTestId);
			dtAGT.Columns.Add("SystemAHGInterp", typeof(string));
			dtAGT.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtAGT.Columns.Add("LotNumberSave", typeof(bool));
			dtAGT.Columns.Add("VialIDSave", typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
			dtAGT.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(int));
			dtAGT.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));
			dtAGT.Columns.Add(ARTIFICIAL.ISGuid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.RTGuid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.C37Guid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.AHGGuid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtAGT.Columns.Add(ARTIFICIAL.InterpGuid, typeof(Guid));

			dtAGT.Columns.Add(ARTIFICIAL.ISRowVersion, typeof(byte[]));
			dtAGT.Columns.Add(ARTIFICIAL.RTRowVersion, typeof(byte[]));
			dtAGT.Columns.Add(ARTIFICIAL.C37RowVersion, typeof(byte[]));
			dtAGT.Columns.Add(ARTIFICIAL.AHGRowVersion, typeof(byte[]));
			dtAGT.Columns.Add(ARTIFICIAL.CCRowVersion, typeof(byte[]));
			dtAGT.Columns.Add(ARTIFICIAL.InterpRowVersion, typeof(byte[]));
			dtAGT.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
			dtAGT.Columns.Add(TABLES.Rack.RackGuid, typeof(System.Guid));
			dtAGT.Columns.Add("CprsOrderNumber");

			DataRow drAGT = dtAGT.NewRow();
			drAGT["PatientGuid"] = patientGuid;
			drAGT["PatientSpecimenGuid"] = patientSpecimenGuid;
			drAGT["OrderedTestGuid"] = orderedTestGuidAGT;
			drAGT[ARTIFICIAL.VialId] = "1";
			drAGT[ARTIFICIAL.AHG] = "2";
			drAGT[ARTIFICIAL.CC] = "3";
			drAGT[ARTIFICIAL.Interp] = "P";

			drAGT["VialIDSave"] = true;
			drAGT[ARTIFICIAL.AHGSave] = true;
			drAGT[ARTIFICIAL.CCSave] = true;
			drAGT[ARTIFICIAL.InterpSave] = true;

			drAGT[ARTIFICIAL.PartiallyCompleted] = true;
			drAGT[TABLES.OrderableTest.OrderableTestId] = "12";
			drAGT[TABLES.ReactivityPhase.ReactivityPhaseCode] = (int)Common.ReactivityPhase.AHGandCC;
			drAGT["TestType"] = "Patient";
			drAGT[TABLES.SpecimenTest.CorrectedResultIndicator] = true;
			drAGT[ARTIFICIAL.OrderedTestRowVersion] = rowVersionOrderedTestAGT;
			drAGT[TABLES.Reagent.ReagentGuid] = reagentGuid;
            drAGT["CprsOrderNumber"] = SprocHelper.GetNewCprsOrderNumber();

			dtAGT.Rows.Add(drAGT);

			dsTestResults.Tables.Add(dtAGT);

			DataTable dtAntibodyIDs = new DataTable("ABID");
			dtAntibodyIDs.Columns.Add("AntibodyTypeId", typeof(int));
			dtAntibodyIDs.Columns.Add("AntibodyTypeName");
			dtAntibodyIDs.Columns.Add("OffsiteLocation");
			dtAntibodyIDs.Columns.Add("OffsiteCost", typeof(decimal));
			dtAntibodyIDs.Columns.Add("CannedCommentGuid", typeof(Guid));
			dtAntibodyIDs.Columns.Add("TestComments");
			dtAntibodyIDs.Columns.Add("OrderedTestGuid", typeof(Guid));
			dtAntibodyIDs.Columns.Add("PatientSpecimenGuid", typeof(Guid));
			dtAntibodyIDs.Columns.Add("PatientGuid", typeof(Guid));
			dtAntibodyIDs.Columns.Add(TABLES.OrderableTest.OrderableTestId, typeof(int));
			dtAntibodyIDs.Columns.Add("OffsiteIndicator", typeof(bool));
			dtAntibodyIDs.Columns.Add(TABLES.SpecimenTest.CorrectedResultIndicator, typeof(bool));
			dtAntibodyIDs.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
			dtAntibodyIDs.Columns.Add("CprsOrderNumber");

			DataRow drAntibodyID = dtAntibodyIDs.NewRow();
			drAntibodyID["AntibodyTypeId"] = 29;
			drAntibodyID["AntibodyTypeName"] = "Anti-K";
			drAntibodyID["OffsiteLocation"] = "Kansas";
			drAntibodyID["OffsiteCost"] = 10;
			drAntibodyID["TestComments"] = "";
			drAntibodyID[TABLES.OrderableTest.OrderableTestId] = 8;
			drAntibodyID["PatientGuid"] = patientGuid;
			drAntibodyID["PatientSpecimenGuid"] = patientSpecimenGuid;
			drAntibodyID["OrderedTestGuid"] = orderedTestGuidABID;
			drAntibodyID["OffsiteIndicator"] = false;
			drAntibodyID[TABLES.SpecimenTest.CorrectedResultIndicator] = true;
			drAntibodyID[ARTIFICIAL.OrderedTestRowVersion] = rowVersionOrderedTestABID;

			dtAntibodyIDs.Rows.Add(drAntibodyID);

			dsTestResults.Tables.Add(dtAntibodyIDs);
			dsTestResults.Tables.Add(new DataTable("ABIDProcess"));

			DataTable dtRacks = DAL.Rack.GetDailyQCRacks(DateTime.Now);
			if (dtRacks.Rows.Count == 0) DataCreator.CreateQCdRack();
			dtRacks = DAL.Rack.GetDailyQCRacks(DateTime.Now);
			Common.LogonUser.LogonUserDivisionCode = UnitTestConfig.TestDivisionCode;
			ArrayList workloadProcessIds = new ArrayList();
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfuseUnit);
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UnitLogin);
			workloadProcessIds.Add(Common.WorkloadProcessID.TransfuseUnit);
			workloadProcessIds.Add(Common.WorkloadProcessID.UnitLogin);
			bool msg = false;
			result = BOL.OrderedTest.SaveTestResults(dsTestResults, new ArrayList(), DateTime.Now, "UnitTest.PatientChange", Common.TestingMethod.Gel, Common.ReactivityPhase.All, (Guid)dtRacks.Rows[0][TABLES.Rack.RackGuid], "", false, Common.UpdateFunction.UnitTests,workloadProcessIds, Guid.NewGuid(), new ArrayList(), ref msg);
			//
			Assert.IsTrue(result == true);

			#endregion
			//
			StringBuilder query = new StringBuilder();
			// 
			Guid patientChangeGuid = Guid.NewGuid();
			//
			query.Remove(0, query.Length);
			query.Append("DECLARE @now DATETIME ");
			query.Append("DECLARE @newdob DATETIME ");
			query.Append("DECLARE @dob DATETIME ");
			query.Append("DECLARE @ssn CHAR(9) ");
			query.Append("DECLARE @lastname	VARCHAR(20) ");
			query.Append("DECLARE @firstname VARCHAR(20) ");
			query.Append("DECLARE @middlename VARCHAR(20) ");
			query.Append("SET @now = DATEADD(MINUTE, 1, GETUTCDATE()) ");       //NotificationDate needs to be > LastUpdateDate of Patient
			query.Append("SET @dob = (SELECT PatientDob FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @ssn = (SELECT PatientSsn FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @lastname	= (SELECT PatientLastName FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @firstname = (SELECT PatientFirstName FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @middlename = (SELECT PatientMiddleName FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @newdob = DATEADD(YEAR, -10, @dob) ");
			query.Append("INSERT INTO PatientChange(PatientChangeGuid, FromPatientGuid, FromPatientSsn, FromPatientLastName, ");
			query.Append("FromPatientFirstName, FromPatientMiddleName,  FromPatientDob, FromPatientDeathDate, ToPatientGuid, ");
			query.Append("ToPatientSsn, ToPatientLastName, ToPatientFirstName, ToPatientMiddleName, ToPatientDob, ToPatientDeathDate, ");
			query.Append("PatientChangeStatusCode, NotificationReceivedDate, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId) VALUES( ");
			query.Append("'").Append(patientChangeGuid).Append("', ");
			query.Append("'").Append(patientGuid).Append("', ");
			query.Append("@ssn, ");
			query.Append("@lastname, ");
			query.Append("@firstname, ");
			query.Append("@middlename, ");
			query.Append("@dob, ");
			query.Append((setDeathDate ? "@now, " : "NULL, "));
			query.Append("'").Append(patientGuid).Append("', ");
			query.Append("'101010101', ");
			query.Append("'UPDATED', ");
			query.Append("'PATIENT', ");
			query.Append("'IS', ");
			query.Append("@newdob, ");
			query.Append((setDeathDate ? "@now, " : "NULL, "));
			query.Append("'P', ");
			query.Append("@now, ");
			query.Append("@now, ");
			query.Append("'UNITTEST', ");
			query.Append("'0') ");
			//
			int rowCount = UnitTestUtil.RunSQL(query.ToString());
			//
			Assert.IsTrue(rowCount > 0, "UNABLE TO INSERT PATIENT CHANGE DATA!");
			//
			return patientChangeGuid;
		}

		/// <summary>
		/// Insert Patient Change for patient with component orders
		/// </summary>
		/// <param name="setDeathDate"></param>
		/// <returns></returns>
		public static Guid InsertUpdatedPatientTestDataWithComponentOrders(bool setDeathDate)
		{		
			Guid patientGuid = Guid.NewGuid();
			System.Diagnostics.Debug.WriteLine(patientGuid.ToString());

			DataTable dtInsPatient = SprocHelper.GetInsertPatientSprocTable(patientGuid);
			bool retValue = BOL.Patient.InsertPatient(dtInsPatient.Rows[0], Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, retValue, "PatientInsert");

			//I am stuck on band-aids, cuz band-aids are stuck on me!
			//This is done to make the test pass 100% of the time - the problem is that sometimes the code would run too fast, 
			//causing the LastUpdateDate in Patient to match PatientChange, which fails the spGetRecentlyUpdatedPatientDetails WHERE clause.
			//MAN - this bug a little street walker!
			System.Threading.Thread.Sleep(420);

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderReceivedDatetime + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
            insertOrderedComponent += "'" + SprocHelper.GetNewCprsOrderNumber() + "',";
			insertOrderedComponent += "'2',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'I',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'" + Environment.UserName + "',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedComponent);

			StringBuilder query = new StringBuilder();
			// 
			Guid patientChangeGuid = Guid.NewGuid();
			//
			query.Remove(0, query.Length);
			query.Append("DECLARE @now DATETIME ");
			query.Append("DECLARE @newdob DATETIME ");
			query.Append("DECLARE @dob DATETIME ");
			query.Append("DECLARE @ssn CHAR(9) ");
			query.Append("DECLARE @lastname	VARCHAR(20) ");
			query.Append("DECLARE @firstname VARCHAR(20) ");
			query.Append("DECLARE @middlename VARCHAR(20) ");
			query.Append("SET @now = GETUTCDATE() ");
			query.Append("SET @dob = (SELECT PatientDob FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @ssn = (SELECT PatientSsn FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @lastname	= (SELECT PatientLastName FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @firstname = (SELECT PatientFirstName FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @middlename = (SELECT PatientMiddleName FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @newdob = DATEADD(YEAR, -10, @dob) ");
			query.Append("INSERT INTO PatientChange(PatientChangeGuid, FromPatientGuid, FromPatientSsn, FromPatientLastName, ");
			query.Append("FromPatientFirstName, FromPatientMiddleName,  FromPatientDob, FromPatientDeathDate, ToPatientGuid, ");
			query.Append("ToPatientSsn, ToPatientLastName, ToPatientFirstName, ToPatientMiddleName, ToPatientDob, ToPatientDeathDate, ");
			query.Append("PatientChangeStatusCode, NotificationReceivedDate, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId) VALUES( ");
			query.Append("'").Append(patientChangeGuid).Append("', ");
			query.Append("'").Append(patientGuid).Append("', ");
			query.Append("@ssn, ");
			query.Append("@lastname, ");
			query.Append("@firstname, ");
			query.Append("@middlename, ");
			query.Append("@dob, ");
			query.Append((setDeathDate ? "@now, " : "NULL, "));
			query.Append("'").Append(patientGuid).Append("', ");
			query.Append("'101010101', ");
			query.Append("'UPDATED', ");
			query.Append("'PATIENT', ");
			query.Append("'IS', ");
			query.Append("@newdob, ");
			query.Append((setDeathDate ? "@now, " : "NULL, "));
			query.Append("'P', ");
			query.Append("@now, ");
			query.Append("@now, ");
			query.Append("'UNITTEST', ");
			query.Append("'0') ");
			//
			int rowCount = UnitTestUtil.RunSQL(query.ToString());

			Assert.IsTrue(rowCount > 0, "UNABLE TO INSERT PATIENT CHANGE DATA!");
			//
			return patientChangeGuid;
		}

		/// <summary>
		/// Insert Patient Change for patient with component orders
		/// </summary>
		/// <param name="setDeathDate"></param>
		/// <returns></returns>
		public static Guid InsertUpdatedPatientTestDataWithExpiredComponentOrders(bool setDeathDate)
		{		
			Guid patientGuid = Guid.NewGuid();
			DataTable dtInsPatient = SprocHelper.GetInsertPatientSprocTable(patientGuid);
			bool retValue = BOL.Patient.InsertPatient(dtInsPatient.Rows[0], Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, retValue, "PatientInsert");

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'" + Environment.UserName + "',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
			insertPatientOrder += TABLES.PatientOrder.OrderReceivedDatetime + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now.AddDays(-12)) + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'" + Environment.UserName + "',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
            insertOrderedComponent += "'" + SprocHelper.GetNewCprsOrderNumber() + "',";
			insertOrderedComponent += "'2',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'I',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'" + Environment.UserName + "',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedComponent);

			StringBuilder query = new StringBuilder();
			// 
			Guid patientChangeGuid = Guid.NewGuid();
			//
			query.Remove(0, query.Length);
			query.Append("DECLARE @now DATETIME ");
			query.Append("DECLARE @newdob DATETIME ");
			query.Append("DECLARE @dob DATETIME ");
			query.Append("DECLARE @ssn CHAR(9) ");
			query.Append("DECLARE @lastname	VARCHAR(20) ");
			query.Append("DECLARE @firstname VARCHAR(20) ");
			query.Append("DECLARE @middlename VARCHAR(20) ");
			query.Append("SET @now = GETUTCDATE() ");
			query.Append("SET @dob = (SELECT PatientDob FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @ssn = (SELECT PatientSsn FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @lastname	= (SELECT PatientLastName FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @firstname = (SELECT PatientFirstName FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @middlename = (SELECT PatientMiddleName FROM Patient WHERE PatientGuid = '").Append(patientGuid).Append("')");
			query.Append("SET @newdob = DATEADD(YEAR, -10, @dob) ");
			query.Append("INSERT INTO PatientChange(PatientChangeGuid, FromPatientGuid, FromPatientSsn, FromPatientLastName, ");
			query.Append("FromPatientFirstName, FromPatientMiddleName,  FromPatientDob, FromPatientDeathDate, ToPatientGuid, ");
			query.Append("ToPatientSsn, ToPatientLastName, ToPatientFirstName, ToPatientMiddleName, ToPatientDob, ToPatientDeathDate, ");
			query.Append("PatientChangeStatusCode, NotificationReceivedDate, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId) VALUES( ");
			query.Append("'").Append(patientChangeGuid).Append("', ");
			query.Append("'").Append(patientGuid).Append("', ");
			query.Append("@ssn, ");
			query.Append("@lastname, ");
			query.Append("@firstname, ");
			query.Append("@middlename, ");
			query.Append("@dob, ");
			query.Append((setDeathDate ? "@now, " : "NULL, "));
			query.Append("'").Append(patientGuid).Append("', ");
			query.Append("'101010101', ");
			query.Append("'UPDATED', ");
			query.Append("'PATIENT', ");
			query.Append("'IS', ");
			query.Append("@newdob, ");
			query.Append((setDeathDate ? "@now, " : "NULL, "));
			query.Append("'P', ");
			query.Append("@now, ");
			query.Append("@now, ");
			query.Append("'UNITTEST', ");
			query.Append("'0') ");
			//
			int rowCount = UnitTestUtil.RunSQL(query.ToString());
			//
			Assert.IsTrue(rowCount > 0, "UNABLE TO INSERT PATIENT CHANGE DATA!");
			//
			return patientChangeGuid;
		}

		/// <summary>
		/// </summary>
		/// <returns>Guid</returns>
		private static Guid CreatePatientTestData(BOL.AboRh aboRh)
		{
			Guid patientGuid = Guid.NewGuid();

			DataTable dtInsPatient = SprocHelper.GetInsertPatientSprocTable(patientGuid);
			bool retValue = BOL.Patient.InsertPatient(dtInsPatient.Rows[0], Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, retValue, "PatientInsert");

			UnitTestUtil.RunSQL("UPDATE Patient SET BloodTypeCode = '" + aboRh.Abo.ToString() + "', RhFactorCode = '" + aboRh.RHFactorCode + "' WHERE PatientGuid = '" + patientGuid.ToString() + "'");

			return patientGuid;
		}

		#endregion

		#region Clear Test Data

		/// <summary>
		/// Clears patient test data from PatientChange
		/// </summary>
		/// <returns>Row change count</returns>
		public void ClearPatientChangeTestData()
		{
			UnitTestUtil.RunSQL("DELETE FROM PatientChange");
		}

		private void DeletePatientTestData(Guid patientGuid)
		{
			UnitTestUtil.RunSQL("DELETE FROM PatientTreatment WHERE PatientGuid = '" + patientGuid.ToString() + "'");
			UnitTestUtil.RunSQL("DELETE FROM Patient WHERE PatientGuid ='" + patientGuid.ToString() + "'");
		}

		#region Transfusion Requirements

		private void SetupAntibodyR(BOL.Patient patient, Guid bloodUnitGuid, string transfusionRequirement, int antibodyTypeId)
		{
			DataTable dtInsertSpecialInstructions = BOL.PatientSpecialInstruction.InitializeSpecialInstructionsTable(false);
			DataTable dtUpdateSpecialInstructions = BOL.PatientSpecialInstruction.InitializeSpecialInstructionsTable(true);
			DataTable dtInsertTransfusionRequirements = BOL.PatientTransfusionRequirement.InitializeTransfusionRequirementsTable(false);
			DataTable dtUpdateTransfusionRequirements = BOL.PatientTransfusionRequirement.InitializeTransfusionRequirementsTable(true);
					
			BOL.PatientTransfusionRequirement trAntibody = new BOL.PatientTransfusionRequirement(patient, transfusionRequirement, Common.TransfusionRequirementCategoryCode.AntibodyIdentified, UnitTestConfig.TestDivisionCode);
			DataRow drAntibody = dtInsertTransfusionRequirements.NewRow();

			Guid antibodyGuid = Guid.NewGuid();
			drAntibody[Common.VbecsTables.PatientTransfusionRequirement.PatientTransfusionRequirementGuid] = antibodyGuid;
			drAntibody[Common.VbecsTables.PatientSpecialInstruction.PatientGuid] = patient.PatientGuid;
			drAntibody[Common.VbecsTables.PatientTransfusionRequirement.TransfusionRequirementText] = trAntibody.TransfusionRequirement;
			drAntibody[Common.VbecsTables.PatientTransfusionRequirement.TransfusionRequirementCategoryCode] = Common.Utility.GetTransfusionCategoryCodeFromEnum( trAntibody.TransfusionRequirementCategoryCode );
			drAntibody[Common.VbecsTables.PatientTransfusionRequirement.CreateDate] = trAntibody.CreateDate;
			drAntibody[Common.VbecsTables.PatientTransfusionRequirement.CreateUser] = trAntibody.CreateUser;
			drAntibody[Common.VbecsTables.PatientTransfusionRequirement.CreateDivisionCode] = trAntibody.CreateDivisionCode;
			drAntibody[Common.VbecsTables.PatientTransfusionRequirement.VistaConversionIndicator] = false;
			drAntibody[Common.VbecsTables.PatientTransfusionRequirement.AntibodyTypeId] = antibodyTypeId;
			drAntibody[Common.VbecsTables.PatientTransfusionRequirement.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
			drAntibody[Common.VbecsTables.PatientTransfusionRequirement.LastUpdateUser] = UnitTestConfig.User_Technologist;
			drAntibody[Common.VbecsTables.PatientTransfusion.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			dtInsertTransfusionRequirements.Rows.Add(drAntibody);

			BOL.Patient.SaveSIsAndTRs(dtInsertSpecialInstructions, dtUpdateSpecialInstructions, dtInsertTransfusionRequirements, dtUpdateTransfusionRequirements, Common.UpdateFunction.UnitTests);
			UnitTestUtil.RunSQL("DELETE FROM BloodUnitAntigen WHERE BloodUnitGuid = '" + bloodUnitGuid.ToString() + "'");
		}
		
		private void SetupAntigenTr
			(
			BOL.Patient patient, Guid bloodUnitGuid, string transfusionRequirement, Common.TransfusionRequirementCategoryCode category, int antigenTypeId
			)
		{
			DataTable dtInsertSpecialInstructions = BOL.PatientSpecialInstruction.InitializeSpecialInstructionsTable(false);
			DataTable dtUpdateSpecialInstructions = BOL.PatientSpecialInstruction.InitializeSpecialInstructionsTable(true);
			DataTable dtInsertTransfusionRequirements = BOL.PatientTransfusionRequirement.InitializeTransfusionRequirementsTable(false);
			DataTable dtUpdateTransfusionRequirements = BOL.PatientTransfusionRequirement.InitializeTransfusionRequirementsTable(true);
					
			BOL.PatientTransfusionRequirement trAntigen = new BOL.PatientTransfusionRequirement(patient, transfusionRequirement, category, UnitTestConfig.TestDivisionCode);
			DataRow drAntigen = dtInsertTransfusionRequirements.NewRow();

			Guid antigenGuid = Guid.NewGuid();
			drAntigen[Common.VbecsTables.PatientTransfusionRequirement.PatientTransfusionRequirementGuid] = antigenGuid;
			drAntigen[Common.VbecsTables.PatientSpecialInstruction.PatientGuid] = patient.PatientGuid;
			drAntigen[Common.VbecsTables.PatientTransfusionRequirement.TransfusionRequirementText] = trAntigen.TransfusionRequirement;
			drAntigen[Common.VbecsTables.PatientTransfusionRequirement.TransfusionRequirementCategoryCode] = Common.Utility.GetTransfusionCategoryCodeFromEnum( trAntigen.TransfusionRequirementCategoryCode );
			drAntigen[Common.VbecsTables.PatientTransfusionRequirement.CreateDate] = trAntigen.CreateDate;
			drAntigen[Common.VbecsTables.PatientTransfusionRequirement.CreateUser] = trAntigen.CreateUser;
			drAntigen[Common.VbecsTables.PatientTransfusionRequirement.CreateDivisionCode] = trAntigen.CreateDivisionCode;
			drAntigen[Common.VbecsTables.PatientTransfusionRequirement.VistaConversionIndicator] = false;
			drAntigen[Common.VbecsTables.PatientTransfusionRequirement.AntigenTypeId] = antigenTypeId;
			drAntigen[Common.VbecsTables.PatientTransfusionRequirement.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
			drAntigen[Common.VbecsTables.PatientTransfusionRequirement.LastUpdateUser] = UnitTestConfig.User_Technologist;
			drAntigen[Common.VbecsTables.PatientTransfusion.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			dtInsertTransfusionRequirements.Rows.Add(drAntigen);

			Assert.IsTrue(BOL.Patient.SaveSIsAndTRs(dtInsertSpecialInstructions, dtUpdateSpecialInstructions, dtInsertTransfusionRequirements, dtUpdateTransfusionRequirements, Common.UpdateFunction.UnitTests));
		}

		private void AddDataRow(DataTable dtCrs, Common.ComponentRequirement req, BOL.PatientTransfusionRequirement pTR, BOL.Patient patient)
		{
			DataRow drTRs = dtCrs.NewRow();
			drTRs[TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid] = System.Guid.NewGuid();
			drTRs[TABLES.PatientSpecialInstruction.PatientGuid] = patient.PatientGuid;
			drTRs[TABLES.PatientTransfusionRequirement.TransfusionRequirementText] = pTR.TransfusionRequirement;
			drTRs[TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode] = Common.Utility.GetTransfusionCategoryCodeFromEnum( pTR.TransfusionRequirementCategoryCode );
			drTRs[TABLES.PatientTransfusionRequirement.CreateDate] = pTR.CreateDate;
			drTRs[TABLES.PatientTransfusionRequirement.CreateUser] = pTR.CreateUser;
			drTRs[TABLES.PatientTransfusionRequirement.CreateDivisionCode] = pTR.CreateDivisionCode;
			drTRs[TABLES.PatientTransfusionRequirement.VistaConversionIndicator] = false;
			drTRs[TABLES.PatientTransfusionRequirement.ComponentRequirementId] = (int) req;
			drTRs[TABLES.PatientTransfusionRequirement.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
			drTRs[TABLES.PatientTransfusionRequirement.LastUpdateUser] = UnitTestConfig.User_Technologist;
			drTRs[TABLES.PatientTransfusion.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			dtCrs.Rows.Add(drTRs);
		}

		private void SetupAllCrs(BOL.Patient patient)
		{
			DataTable dtInsertSpecialInstructions = BOL.PatientSpecialInstruction.InitializeSpecialInstructionsTable(false);
			DataTable dtUpdateSpecialInstructions = BOL.PatientSpecialInstruction.InitializeSpecialInstructionsTable(true);
			DataTable dtInsertTransfusionRequirements = BOL.PatientTransfusionRequirement.InitializeTransfusionRequirementsTable(false);
			DataTable dtUpdateTransfusionRequirements = BOL.PatientTransfusionRequirement.InitializeTransfusionRequirementsTable(true);

			UnitTestUtil.RunSQL("DELETE FROM PatientTransfusionRequirement WHERE PatientGuid = '" + patient.PatientGuid + "'");
		
			// Irradiated
			BOL.PatientTransfusionRequirement pTR = new BOL.PatientTransfusionRequirement(patient, "Irradiated cellular products", Common.TransfusionRequirementCategoryCode.ComponentRequirement, UnitTestConfig.TestDivisionCode);
			Common.ComponentRequirement req = Common.ComponentRequirement.IRRADIATE;
			AddDataRow(dtInsertTransfusionRequirements, req, pTR, patient);

			// Leuko
			pTR = new BOL.PatientTransfusionRequirement(patient, "Leuko-reduced cellular products", Common.TransfusionRequirementCategoryCode.ComponentRequirement, UnitTestConfig.TestDivisionCode);
			req = Common.ComponentRequirement.LEUKORED;
			AddDataRow(dtInsertTransfusionRequirements, req, pTR, patient);

			// Washed RBC
			pTR = new BOL.PatientTransfusionRequirement(patient, "Washed RBC products", Common.TransfusionRequirementCategoryCode.ComponentRequirement, UnitTestConfig.TestDivisionCode);
			req = Common.ComponentRequirement.WASHEDRBC;
			AddDataRow(dtInsertTransfusionRequirements, req, pTR, patient);

			// Washed PLT
			pTR = new BOL.PatientTransfusionRequirement(patient, "Washed PLT products", Common.TransfusionRequirementCategoryCode.ComponentRequirement, UnitTestConfig.TestDivisionCode);
			req = Common.ComponentRequirement.WASHEDPLT;
			AddDataRow(dtInsertTransfusionRequirements, req, pTR, patient);

			// Sickle cell
			pTR = new BOL.PatientTransfusionRequirement(patient, "Sickle Cell Negative RBC products", Common.TransfusionRequirementCategoryCode.ComponentRequirement, UnitTestConfig.TestDivisionCode);
			req = Common.ComponentRequirement.SCNEG;
			AddDataRow(dtInsertTransfusionRequirements, req, pTR, patient);

			// CMV Neg
			pTR = new BOL.PatientTransfusionRequirement(patient, "CMV Negative cellular products", Common.TransfusionRequirementCategoryCode.ComponentRequirement, UnitTestConfig.TestDivisionCode);
			req = Common.ComponentRequirement.CMVNEG;
			AddDataRow(dtInsertTransfusionRequirements, req, pTR, patient);
		
			bool success = BOL.Patient.SaveSIsAndTRs(dtInsertSpecialInstructions, dtUpdateSpecialInstructions, dtInsertTransfusionRequirements, dtUpdateTransfusionRequirements, Common.UpdateFunction.UnitTests);
			Assert.IsTrue(success);
		}

		private void SetupIrradiatedCr(BOL.Patient patient)
		{
			DataTable dtInsertSpecialInstructions = BOL.PatientSpecialInstruction.InitializeSpecialInstructionsTable(false);
			DataTable dtUpdateSpecialInstructions = BOL.PatientSpecialInstruction.InitializeSpecialInstructionsTable(true);
			DataTable dtInsertTransfusionRequirements = BOL.PatientTransfusionRequirement.InitializeTransfusionRequirementsTable(false);
			DataTable dtUpdateTransfusionRequirements = BOL.PatientTransfusionRequirement.InitializeTransfusionRequirementsTable(true);

			UnitTestUtil.RunSQL("DELETE FROM PatientTransfusionRequirement WHERE PatientGuid = '" + patient.PatientGuid + "'");
		
			// Irradiated
			BOL.PatientTransfusionRequirement pTR = new BOL.PatientTransfusionRequirement(patient, "Irradiated cellular products", Common.TransfusionRequirementCategoryCode.ComponentRequirement, UnitTestConfig.TestDivisionCode);
			Common.ComponentRequirement req = Common.ComponentRequirement.IRRADIATE;
			AddDataRow(dtInsertTransfusionRequirements, req, pTR, patient);

			bool success = BOL.Patient.SaveSIsAndTRs(dtInsertSpecialInstructions, dtUpdateSpecialInstructions, dtInsertTransfusionRequirements, dtUpdateTransfusionRequirements, Common.UpdateFunction.UnitTests);
			Assert.IsTrue(success);
		}

		private void SetupWashedRbcCr(BOL.Patient patient)
		{
			DataTable dtInsertSpecialInstructions = BOL.PatientSpecialInstruction.InitializeSpecialInstructionsTable(false);
			DataTable dtUpdateSpecialInstructions = BOL.PatientSpecialInstruction.InitializeSpecialInstructionsTable(true);
			DataTable dtInsertTransfusionRequirements = BOL.PatientTransfusionRequirement.InitializeTransfusionRequirementsTable(false);
			DataTable dtUpdateTransfusionRequirements = BOL.PatientTransfusionRequirement.InitializeTransfusionRequirementsTable(true);

			UnitTestUtil.RunSQL("DELETE FROM PatientTransfusionRequirement WHERE PatientGuid = '" + patient.PatientGuid + "'");

			// Washed RBC
			BOL.PatientTransfusionRequirement pTR = new BOL.PatientTransfusionRequirement(patient, "Washed RBC products", Common.TransfusionRequirementCategoryCode.ComponentRequirement, UnitTestConfig.TestDivisionCode);
			Common.ComponentRequirement req = Common.ComponentRequirement.WASHEDRBC;
			AddDataRow(dtInsertTransfusionRequirements, req, pTR, patient);
		
			bool success = BOL.Patient.SaveSIsAndTRs(dtInsertSpecialInstructions, dtUpdateSpecialInstructions, dtInsertTransfusionRequirements, dtUpdateTransfusionRequirements, Common.UpdateFunction.UnitTests);
			Assert.IsTrue(success);
		}

		#endregion

		#endregion


		#endregion
	}
}

#endif
